#define _CRT_SECURE_NO_WARNINGS
#include <bits/stdc++.h>

using namespace std;

class Jarbol
{
private:

    long long int x;
    long long int y;
    long long int i;

public:

    long long int getX() { return x; }
    void setX(long long int x) { this->x = x; }
    long long int getY() { return y; }
    void setY(long long int y) { this->y = y; }
    long long int getI() { return i; }
    void setI(long long int i) { this->i = i; }

    long long int PresekDesno(long long int y) { return this->x + this->y - y; }
    long long int PresekLevo(long long int y) { return this->x - this->y + y; }

    static long long int NajbliziVisiLevo(vector <Jarbol>& jarboli, long long int duzina, long long int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        long long int i = indeks-1;
        bool flagNadjen = false;

        for (; i > -1; i--)
        {
            if (jarboli[i].getY() >= pocetni.getY())
            {
                flagNadjen = true;
                break;
            }
        }

        if (!flagNadjen) return -1;
        return pocetni.getX() - jarboli[i].PresekDesno(pocetni.getY());
    }

    static long long int NajbliziVisiDesno(vector <Jarbol>& jarboli, long long int duzina, long long int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        long long int i = indeks+1;
        bool flagNadjen = false;

        for (; i < duzina; i++)
        {
            if (jarboli[i].getY() >= pocetni.getY())
            {
                flagNadjen = true;
                break;
            }
        }

        if (!flagNadjen) return -1;
        return jarboli[i].PresekLevo(pocetni.getY()) - pocetni.getX();

    }
};

int main()
{
    long long int n;
    long long int pom;
    

    scanf("%d", &n);

    vector <Jarbol> jarboli(n);

    for (long long int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setX(pom);
        jarboli[i].setI(i);
    }

    for (long long int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setY(pom);
    }

    sort(jarboli.begin(), jarboli.end(),
        [](Jarbol t1, Jarbol t2) { return t1.getX() < t2.getX(); 
        });

    vector <long long int> output(n);

    long long int najbliziVisiDesno = 0, najbliziVisiLevo = 0;

    for (long long int i = 0; i < n; i++)
    {
        najbliziVisiDesno = Jarbol::NajbliziVisiDesno(jarboli, n, i);
        najbliziVisiLevo = Jarbol::NajbliziVisiLevo(jarboli, n, i);

        if (najbliziVisiDesno == -1 && najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = -1;
        else if (najbliziVisiDesno == -1)
            output[jarboli[i].getI()] = (najbliziVisiLevo);
        else if (najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = (najbliziVisiDesno);
        else
            output[jarboli[i].getI()] = (najbliziVisiDesno < najbliziVisiLevo ? najbliziVisiDesno : najbliziVisiLevo);
    }

    for (long long int i = 0; i < n; i++) printf("%d\n", output[i]);

    return 0;
}